/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.dialogs;

import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.IDialogConstants;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.dialogs.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SudoPasswordPromptDialog
extends Dialog {
    private Text pwdText;
    private Shell shell;
    private char[] password;
    private static final String MAC_DIALOG_FONT = "Lucida Grande";
    private static final int MAC_DIALOG_FONT_SIZE = 13;
    private String promptMessage;
    private static final String SECURITY_IMAGE = "/icons/full/security.png";
    private static final String ARG_STATEMENT = "-e";
    private static final String OSASCRIPT = "osascript";

    public SudoPasswordPromptDialog(IShellProvider parentShell, String promptMessage) {
        super(parentShell);
        this.promptMessage = String.valueOf(promptMessage) + " " + Messages.SudoPasswordPromptDialog_MessagePrompt_Suffix;
    }

    protected void configureShell(Shell newShell) {
        this.shell = newShell;
        newShell.setLayout((Layout)new GridLayout());
    }

    protected void okPressed() {
        this.password = this.pwdText.getText().toCharArray();
        super.okPressed();
    }

    public char[] getPassword() {
        return this.password;
    }

    protected Point getInitialSize() {
        Point computeSize = this.shell.computeSize(440, -1);
        return computeSize;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.pwdText.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        IStatus status;
        FontData msgPromptFontData = new FontData(MAC_DIALOG_FONT, 13, 1);
        final Font msgPromptFont = new Font((Device)this.shell.getDisplay(), msgPromptFontData);
        parent.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).create());
        parent.setFont(msgPromptFont);
        Label authImageLbl = new Label(parent, 0);
        final Image authImage = UIPlugin.getImageDescriptor(SECURITY_IMAGE).createImage();
        authImageLbl.setImage(authImage);
        Label promptMsg = new Label(parent, 64);
        promptMsg.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(1, 1).create());
        promptMsg.setFont(parent.getFont());
        promptMsg.setText(this.promptMessage);
        new Label(parent, 0);
        FontData fieldsFontData = new FontData(MAC_DIALOG_FONT, 13, 0);
        final Font fieldsFont = new Font((Device)this.shell.getDisplay(), fieldsFontData);
        Composite authDetails = new Composite(parent, 0);
        authDetails.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).create());
        authDetails.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 1).create());
        authDetails.setFont(fieldsFont);
        Composite labels = new Composite(authDetails, 0);
        labels.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).create());
        Composite fieldsComp = new Composite(authDetails, 0);
        fieldsComp.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).create());
        fieldsComp.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(4, 1).create());
        Label nameLbl = new Label(labels, 0);
        nameLbl.setText(StringUtil.makeFormLabel((String)Messages.SudoPasswordPromptDialog_User));
        nameLbl.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(0x1000008, 1).create());
        nameLbl.setFont(authDetails.getFont());
        Text nameText = new Text(fieldsComp, 2056);
        nameText.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(4, 4).create());
        nameText.setText(System.getProperty("user.name"));
        if (PlatformUtil.isMac() && (status = new ProcessRunner().runInBackground(new String[]{OSASCRIPT, ARG_STATEMENT, "long user name of (system info)"})) != null && status.isOK() && !StringUtil.isEmpty((String)status.getMessage())) {
            nameText.setText(status.getMessage());
        }
        nameText.setForeground(parent.getDisplay().getSystemColor(33));
        Label pwdLbl = new Label(labels, 0);
        pwdLbl.setText(StringUtil.makeFormLabel((String)Messages.SudoPasswordPromptDialog_Password));
        pwdLbl.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(0x1000008, 1).create());
        pwdLbl.setFont(authDetails.getFont());
        this.pwdText = new Text(fieldsComp, 0x400800);
        this.pwdText.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(4, 4).create());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (authImage != null) {
                    authImage.dispose();
                }
                if (msgPromptFont != null) {
                    msgPromptFont.dispose();
                }
                if (fieldsFont != null) {
                    fieldsFont.dispose();
                }
            }
        });
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        new Label(parent, 0);
        Composite buttonsComp = new Composite(parent, 0);
        buttonsComp.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(0).equalWidth(true).create());
        buttonsComp.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(0x1000008, 1).create());
        this.createButton(buttonsComp, 1, IDialogConstants.CANCEL_LABEL, false);
        Button okBtn = this.createButton(buttonsComp, 0, IDialogConstants.OK_LABEL, true);
        okBtn.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 1).create());
        return parent;
    }
}

